turtles-own [ energy ]
patches-own [ resource-type ]

breed [ recyclers recycler ]
breed [ wastefuls wasteful ]

to setup
  ca
  set-default-shape turtles "person"

  create-recyclers pocet-recyklujicich [
    set color blue
  ]
  create-wastefuls pocet-nesetrnych [
    set color red
  ]

  ask turtles [
    setxy random-pxcor random-pycor
    set energy maximum-energie / 2
  ]

  ask patches [
    set resource-type "new"
    update-patch
  ]
end


to go
  ask recyclers [
    recycler-process-patch
  ]
  ask wastefuls
  [
    wasteful-process-patch
  ]
  ask turtles [
    move
    if (energy > maximum-energie)
      [ set energy maximum-energie ]
    if energy < 0
      [ die ]
  ]

  ifelse (ukazat-energii?)
    [ ask turtles [ set label (round energy) ] ]
    [ ask turtles [ set label "" ] ]

  update-environment
  ask patches [ update-patch ]
  update-plots
  tick
end

to move  ;;procedura elv
  let target-patch one-of neighbors
  if (agenti-hledaji-zdroje?)
  [
    let candidate-moves neighbors with [ resource-type = "new" ]
    ifelse any? candidate-moves
      [ set target-patch one-of candidate-moves ]
    [
      set candidate-moves neighbors with [ resource-type = "recycled" ]
      if any? candidate-moves
        [ set target-patch one-of candidate-moves ]
    ]
  ]
  face target-patch
  move-to target-patch

  set energy (energy - 1)
end

to recycler-process-patch
  ifelse (resource-type = "new" )
  [
    if (energy <= maximum-energie - 2)
      [ set energy energy + 2 ]
  ]
  [
    ifelse (resource-type = "recycled" )
    [
      if (energy <= maximum-energie - 1)
      [
        set energy energy + 1
      ]
    ]
    [
      set energy energy - cena-obnovy
      set resource-type "recycled"
    ]
  ]
end

to wasteful-process-patch
  ifelse (resource-type = "new" )
  [
    if (energy <= maximum-energie - 4)
    [
      set energy energy + 4
     set resource-type "waste"
    ]
  ]
  [
    if (resource-type = "recycled")
    [
      if (energy <= maximum-energie - 2)
      [
        set energy energy + 2
        set resource-type "waste"
      ]
    ]
  ]
  ;; pokud je polko typu "waste", pak elva nezsk dnou energii 

end

to update-patch
  ifelse (resource-type = "new")
    [ set pcolor green ]
  [ ifelse (resource-type = "recycled")
      [ set pcolor lime ]
      [ set pcolor yellow - 1 ]
  ]
end

to update-environment
  ask patches with [ resource-type = "recycled" ]
  [
    if random 100 < (regenerace-zdroju / 10)
      [ set resource-type "new" ]
  ]
  ;; zpustoen polka maj v tomto modelu (narozdl od recyklovanch) nis tendenci se obnovit
  ;; vlivem prosted (pirozenou cestou) - arbitrrn byla zvlolena 5x men pravdpodobnost obnovy
  ask patches with [ resource-type = "waste" ]
  [
    if (random 5 = 0) and (random 100 < (regenerace-zdroju / 10))
      [ set resource-type "new" ]
  ]
end


to update-plots
  set-current-plot "Populace"
  set-current-plot-pen "recyklujc"
  plot count recyclers
  set-current-plot-pen "neetrn"
  plot count wastefuls

  set-current-plot "Vyuit pdy"
  set-current-plot-pen "nov"
  plot (count patches with [ resource-type = "new" ]) / count patches * 100
  set-current-plot-pen "obnoven"
  plot (count patches with [ resource-type = "recycled" ]) / count patches * 100
  set-current-plot-pen "zpustoen"
  plot (count patches with [ resource-type = "waste" ]) / count patches * 100

end

;; Copyright 2007 Uri Wilensky. All rights reserved. Vechna prva vyhrazena.
;; Pln informace o prvnch podmnkch naleznete v sekci Informace.
@#$#@#$#@
GRAPHICS-WINDOW
195
10
625
461
17
17
12.0
1
10
1
1
1
0
1
1
1
-17
17
-17
17
1
1
1
ticks

CC-WINDOW
5
475
873
570
Command Center
0

BUTTON
55
30
133
63
Pipravit
Setup\n
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
105
75
180
108
Start
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

SLIDER
5
120
180
153
pocet-recyklujicich
pocet-recyklujicich
0
50
25
1
1
NIL
HORIZONTAL

SLIDER
5
160
180
193
pocet-nesetrnych
pocet-nesetrnych
0
50
25
1
1
NIL
HORIZONTAL

SWITCH
5
410
180
443
ukazat-energii?
ukazat-energii?
0
1
-1000

SLIDER
5
255
181
288
cena-obnovy
cena-obnovy
0
2
0.5
0.25
1
NIL
HORIZONTAL

SLIDER
5
295
180
328
regenerace-zdroju
regenerace-zdroju
0
100
25
1
1
NIL
HORIZONTAL

SLIDER
5
215
180
248
maximum-energie
maximum-energie
10
100
50
5
1
NIL
HORIZONTAL

MONITOR
635
35
744
80
recyklujc (mod)
count recyclers
17
1
11

MONITOR
750
35
861
80
neetrn (erven)
count wastefuls
17
1
11

SWITCH
0
350
185
383
agenti-hledaji-zdroje?
agenti-hledaji-zdroje?
1
1
-1000

PLOT
635
100
861
250
Populace
as
NIL
0.0
10.0
0.0
10.0
true
false
PENS
"recyklujc" 1.0 0 -13345367 true
"neetrn" 1.0 0 -2674135 true

PLOT
635
270
864
420
Vyuit pdy
as
%
0.0
10.0
0.0
100.0
true
false
PENS
"nov" 1.0 0 -10899396 true
"obnoven" 1.0 0 -13840069 true
"zpustoen" 1.0 0 -4079321 true

BUTTON
5
75
77
108
1x krok
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

@#$#@#$#@
CO TO JE?
---------

Tento model demonstruje dopady chovn agent (lid), ovlivujc pirozen prodn zdroje ve svm prosted v prbhu asu. V tomto zjednoduenm scni jsou pouze dva typy agent - zodpovdn recyklujc lid a agenti neetrn ke svmu prosted.

Recyklujc agenti si vce uvdomuj mnostv prodnch zdroj (potamo penze, uitek atd.), kter vyuvaj. Proto neni pdu pi jejm vyuvn a sna se ji naopak obnovovat. Na druh strani agenti neetrn ke svmu ivotnmu prosted zcela vyerpvaj zdroje na svch stech zem, m dochz k jejmu zpustoen. Zpustoenou pdu nelze dnm zpsobem vyut do doby, ne je obnovena recyklujcmi agenty.

Pestoe je tento model v mnoha ohledech nerealistick, ukazuje velmi podstatn aspekty problematiky vyuvn a udritelnosti prodnch zdroj. Model ukazuje energii a nmahu vynaloenou na udren prosted tak, aby bylo obyvateln. K udren zdroj zde mus nastat rovnovha mezi jejich vyuvnm a obnovovnm. Pestoe recyklace v podob obnovovn zdroj vede ke zlepen ivotnho prosted, stoj dodaten nklady v podob nevyuit plnho potencilu existujcch zdroj a navc sama snaha o recyklaci stoj tak energii. Mimo to je vynaloena dal energie na odklzen odpadu po neetrnch jednotlivcch.

Model me slouit jako vborn podklad pi debatovn o tom, jak ekologicky orientovan pedpoklady jsou i nejsou rozumn a jak jsou jejich mon dsledky. 

JAK TO FUNGUJE?
---------------

ivotn prosted se v modelu skld z mky jednotlivch bunk, kad z nich me bt ve tech rznch stavech: nov (zobrazen zelen), obnoven (svtle zelen) nebo zpustoen (lut). Na zatku jsou v modelu vechny buky v novm stavu.

Existuj zde tak dva typy agent - recyklujc a neetrn k prosted. Agenti maj vlastnost nazvanou energie, kterou zskvaj ze svho prosted. Vichni z nich zanaj s polovin hodnotou jejich maximln energie (urenou posuvnkem MAXIMUM-ENERGIE). Pokud agentovi dojde energie, zmiz. Tato energie me bt voln interpretovna jako penze nebo jin ekonomick (omezen) zdroje - pokud agent o vechny pijde, pak pestv bt platnm hrem tto hry o zdroje.

V kadm asovm kroku agenti nejdve zpracuj zdroje z buky, na kter se nachz a nsledn se pesunou na jednu z osmi sousednch bunk. Pohyb me bt zcela nhodn, nebo me bt elov ve smyslu aktivnho vyhledvn dostupnch zdroj (v ppad, e je pepna AGENTI-HLEDAJI-ZDROJE? v polze ON).

Neetrn agenti vdy zcela zdevastuj zpracovvanou buku tak, e z n vyerpaj veker dostupn zdroje a zanechaj ji ve stavu zpustoen. Zskaj tm 4 body energie z novch bunk, 2 body z obnovench bunk a dn body ze zpustoench bunk.

Recyklujc agenti jsou uvdoml a spotebuj pouze polovinu z dostupnch zdroj na svm polku, m umon pirozenou obnovu danch zdroj. Proto nov buky zstvaj nov i po zpracovn recyklujcmi agenty - ti z nich ovem zskaj pouze 2 body energie. Stejn tak zskaj polovinu energie z bunk se statusem obnoven - tedy 1 bod energie. Pokud se dostanou na zpustoenou buku, vynalo nmahu na jej obnovu, co je ovem stoj energii (jej mnostv lze urit posuvnkem CENA-OBNOVY) namsto jejho zskn.

Navc jsou prodn zdroje nhodn regenerovny samotnm prostedm (v me, kterou lze ovlivnit posuvnkem REGENERACE-ZDROJU). Tmto procesem se buky vrac do stavu nov. Buky ve stavu obnoven se takto dostanou do potenho stavu s ptkrt vy pravdpodobnost ne buky ve stavu zpustoena. Tento ptinsbek byl zvolen arbitrrn, nebo je logick, e zcela znien oblasti se regeneruj pomaleji. 

JAK MODEL OVLDAT
-----------------

Stisknutm tlatka PIPRAVIT nastavte model ke sputn. Vechny buky se vykresl v novm stavu. Recyklujc i neetrn agenti jsou v modelu rozmstni nhodn.

Tlatkem START spustte bh modelu. Stisknutm tlatka 1x KROK posunete model prv o jednu asovou jednotku.

Pomoc POCET-RECYKLUJICICH a POCET-NESETRNYCH nastavte celkov poet agent v jednotlivch skupinch.

Posuvnk MAXIMUM-ENERGIE uruje nejvy mon mnostv bod energie, kter me agent nahromadit. Pokud by zpracovnm buky zskal agent vce bod ne je toto maximum, pak agent tuto buku vbec nezpracuje.

Posuvnk CENA-OBNOVY ovlivuje, kolik energie bude recyklujc agenty stt pemna buky ze stavu zpustoen do stavu obnoven.

REGENERACE-ZDROJU ovld mru, s jakou jsou zdroje pirozen regenerovny prostedm. Hodnota 0 znamen, e se prosted neregeneruje vbec, a hodnota 100 naopak znamen, e se obnovuje velmi rychle.

Pokud je spna AGENTI-HLEDAJI-ZDROJE? v polze ON, pak agenti (dve ne se pesunou) prozkoumaj svch okolnch osm bunk a pokus se pemstit na buku ve stavu nov. Pokud dn neexistuje, pokus se posunout na buku ve stavu obnoven. Pokud ani ta v jejich okol nen, posunou se na nhodnou z okolnch bunk. Pokud je ovem zmnn spna v poloze OFF, pak se agenti vdy pohybuj na sousedn buky nhodn.

Pokud je UKAZAT-ENERGII? v poloze ON, pak je v modelu nad kadm agentem zobrazeno slo reprezentujc jeho aktuln mnostv energie.

Aktuln poet recyklujcch a neetrnch agent v modelu je zobrazen v ukazatelch RECYKLUJC (MOD) a NEETRN (ERVEN).

Vvoj populace v prbhu asu je vykreslovn v grafu nazvanm POPULACE.

VYUIT PDY zaznamenv poet bunk v jednotlivch stavech: nov, obnoven a zpustoen. 

VIMNTE SI
------------

V tomto modelu je tak dleit maximln nosn kapacita prosted. Tato kapacita udv, kolik agent me v prosted t relativn udritelnm zpsobem. Odpov na tuto otzku zle na tom, o jakch typech agent je e. V tomto modelu umouje prosted snadn peit pomrn velkho mnostv recyklujcch agent. Pesto existuje omezen pro mnostv agent neetrnch ke svmu prosted. Kapacita pro tento typ agent zvis na nkolika faktorech - mimo jin na parametru OBNOVA-ZDROJU a potu recyklujcch agent. 

VYZKOUEJTE SI
--------------

Nastavte MAXIMUM-ENERGIE na hodnotu 50, CENA-OBNOVY na 0,5 a REGENERACE-ZDROJU na 25. Spuste model s 25 recyklujcmi a 25 neetrnmi agenty na dobu 10 000 asovch krok. Kolik agent z obou druh peilo? Nyn spuste model na stejnou dobu s 50 recyklujcmi a 25 neetrnmi agenty. Klolik z nich tentokrt peilo od kadho druhu?

Spuste model bez recyklujcch agent, pouze s 50 neetrnmi agenty. Sledujte graf Vyuit pdy. Buky zanaj ve stavu nov, avak v prbhu asu se na jejich kor zvyuje mnostv bunk ve stavu zpustoen, a doshne vyuit pdy hodnoty kolem 75 %. Po dosaen tto hodnoty opt mnostv zpustoench bunk kles a pod hranici 25 %. Podvejte se na grafy a srovnejte, jak spolu souvis velikost populace a vyuit pdy. 

ROZEN MODELU
----------------

Omezen MAXIMUM-ENERGIE existuje z toho dvodu, e bez tohoto limitu by byla dna pli velk vhoda neetrnm agentm. Ti by nasli obrovsk mnostv energie (nebo zskvaj dvojnsobek energie ne recyklujc agenti) na kor recyklujcch agent, kte by vymeli. Pokuste se vymyslet jin zpsob, jak udret rovnovhu v tomto modelu bez vyuit omezujcho parametru MAXIMUM-ENERGIE. 

PROGRAMOVAC ZAJMAVOSTI NETLOGA

Funkce UKAZAT-ENERGII? vyuv schopnost NetLoga zobrazit nad kadm agentem hodnotu nkter z jeho vlastnost. Tou me bt seln hodnota i text. V tomto konkrtnm ppad ukazujeme hladinu energie pomoc kdu: ASK TURTLES [ SET LABEL (ROUND ENERGY) ]. Tmto je nejdve zaokrouhlena hodnota energie (jeliko v modelu nechceme sledovat dlouh desetinn sla jako 48,25) a pot je hodnota vykreslena v modelu nad agenty. 

SOUVISEJC MODELY
------------------

Tento model souvis se vemi ostatnmi modely kategorie Urban Site.

Prvn verze tohoto modelu byly inspirovny modelem Kooperace (Cooperation) ze zkladn knihovny model NetLoga. Model Kooperace se vnuje otzce, jak me mezilidsk kooperace vzniknout v prbhu biologick evoluce.

PODKOVN A ODKAZY
----------------------
Pvodn verze tohoto modelu byla vyvinuta v rmci kurz Sprawl/Swarm na Illinois Institute of Technology na podzim roku 2006 pod dohledem Sarah Dunn a Martina Felsena nsledujcmi studenty: Anita Phetkhamphou a Tidza Causevic. Pro vce informac o kurzu viz http://www.sprawlcity.us/

Dal modifikace a zdokonalovn modelu byly provedeny leny Center for Connected Learning and Computer-Based Modeling ped vyputnm v rmci skupiny model Urban Suite.

Urban Suite modely byly vyvinuty jako soust projektu Procedural Modeling of Cities, kter byl sponzorovn NSF ITR grantem 0326542, Electronic Arts & Maxis.

Vce informac o projektu nalezenete na http://ccl.northwestern.edu/cities/


JAK CITOVAT
-----------
Pi citovn tohoto modelu ve vdeckch publikacch pouijte prosm nsledujc odkaz:
- Felsen, M. and Wilensky, U. (2007).  NetLogo Urban Suite - Recycling model.  http://ccl.northwestern.edu/netlogo/models/UrbanSuite-Recycling.  Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.
- Wilensky, U. (1999). NetLogo. http://ccl.northwestern.edu/netlogo/. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.

V jinch publikacch uvete prosm tyto informace:
- Copyright 2007 Uri Wilensky. All rights reserved. See http://ccl.northwestern.edu/netlogo/models/UrbanSuite-Recycling for terms of use.


AUTORSK PRVA
----------------
Copyright 1997 Uri Wilensky. Vechna prva vyhrazena.

Oprvnn pouvat, upravovat nebo dle it tento model je udleno, pokud jsou splnny nsledujc podmnky:
a) soust modelu jsou (tato) autorsk prva
b) tento model nebude dle en za elem zisku bez povolen autora (Uri Wilensky). Pro zskn licence ke komernmu vyuit kontaktujte autora.  

@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.0.3
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
